package gov.va.med.mhv.sm.admin.converter;


import org.springframework.stereotype.Component;

import gov.va.med.mhv.sm.admin.jpa.model.Facility;
import gov.va.med.mhv.sm.admin.dto.FacilityDTO;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class SMFacilityConverter {
	
    public static FacilityDTO convert(Facility facility){
    	
    	FacilityDTO dto = new FacilityDTO();
    	
    	dto.setId(facility.getId());
    	dto.setParentId(facility.getParentId());
    	dto.setName(facility.getName());
    	dto.setVisnId(facility.getVisnId());
    	dto.setStationNumber(facility.getStationNumber());
    	
    	return dto;
    }
    
	public static List<FacilityDTO> convertList(List<Facility> source) {

		List<FacilityDTO> destination = new ArrayList<FacilityDTO>();
		for (Facility a : source) {
			destination.add(convert(a));
		}
		return destination;
	}
	
    public static Facility convert(FacilityDTO dto){
    	
    	Facility facility = new Facility();
    	
    	facility.setId(dto.getId());
    	facility.setParentId(dto.getParentId());
    	facility.setName(dto.getName());
    	facility.setVisnId(dto.getVisnId());
    	facility.setStationNumber(dto.getStationNumber());
    	
    	return facility;
    }
	
    
}
